% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fixes.R
\name{modify_xpdb}
\alias{modify_xpdb}
\alias{mutate_x}
\alias{rename_x}
\title{Add, remove or rename variables in an xpdb}
\usage{
mutate_x(.data, ..., .problem, .source, .where)

rename_x(.data, ..., .problem, .source, .where)
}
\arguments{
\item{.data}{An xpose database object.}

\item{...}{Name-value pairs of expressions. Use \code{NULL} to drop a variable.}

\item{.problem}{The problem from which the data will be modified}

\item{.source}{The source of the data in the xpdb. Can either be 'data' or an output
file extension e.g. 'phi'.}

\item{.where}{A vector of element names to be edited in special (e.g.
\code{.where = c('vpc_dat', 'aggr_obs')} with vpc).}
}
\value{
An updated \code{xpose} data object
}
\description{
\code{mutate_x()} adds new variables and preserves existing ones.
\code{select()} keeps only the listed variables; \code{rename()} keeps all variables.

\strong{Note:} this function uses \code{xpose.xtras::edit_xpose_data}, but is otherwise
the same as <\code{\link[xpose:reexports]{xpose::mutate}}>.
}
