% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xml_parse.R
\name{read_xml}
\alias{read_html}
\alias{read_xml}
\alias{read_xml.character}
\alias{read_xml.connection}
\alias{read_xml.raw}
\title{Read HTML or XML.}
\usage{
read_xml(x, encoding = "", ..., as_html = FALSE, options = "NOBLANKS")

read_html(x, encoding = "", ..., options = c("RECOVER", "NOERROR",
  "NOBLANKS"))

\method{read_xml}{character}(x, encoding = "", ..., as_html = FALSE,
  options = "NOBLANKS")

\method{read_xml}{raw}(x, encoding = "", base_url = "", ...,
  as_html = FALSE, options = "NOBLANKS")

\method{read_xml}{connection}(x, encoding = "", n = 64 * 1024,
  verbose = FALSE, ..., base_url = "", as_html = FALSE,
  options = "NOBLANKS")
}
\arguments{
\item{x}{A string, a connection, or a raw vector.

  A string can be either a path, a url or literal xml. Urls will
  be converted into connections either using \code{base::url} or, if
  installed, \code{curl::curl}. Local paths ending in \code{.gz},
  \code{.bz2}, \code{.xz}, \code{.zip} will be automatically uncompressed.

  If a connection, the complete connection is read into a raw vector before
  being parsed.}

\item{encoding}{Specify a default encoding for the document. Unless
otherwise specified XML documents are assumed to be in UTF-8 or
UTF-16. If the document is not UTF-8/16, and lacks an explicit
encoding directive, this allows you to supply a default.}

\item{...}{Additional arguments passed on to methods.}

\item{as_html}{Optionally parse an xml file as if it's html.}

\item{options}{Set parsing options for the libxml2 parser. These are
specified as a character vector of options to set. Available values are
\describe{
  \item{RECOVER}{recover on errors}
  \item{NOENT}{substitute entities}
  \item{DTDLOAD}{load the external subset}
  \item{DTDATTR}{default DTD attributes}
  \item{DTDVALID}{validate with the DTD}
  \item{NOERROR}{suppress error reports}
  \item{NOWARNING}{suppress warning reports}
  \item{PEDANTIC}{pedantic error reporting}
  \item{NOBLANKS}{remove blank nodes}
  \item{SAX1}{use the SAX1 interface internally}
  \item{XINCLUDE}{Implement XInclude substitition}
  \item{NONET}{Forbid network access}
  \item{NODICT}{Do not reuse the context dictionary}
  \item{NSCLEAN}{remove redundant namespaces declarations}
  \item{NOCDATA}{merge CDATA as text nodes}
  \item{NOXINCNODE}{do not generate XINCLUDE START/END nodes}
  \item{COMPACT}{compact small text nodes; no modification of the tree allowed afterwards (will possibly crash if you try to modify the tree)}
  \item{OLD10}{parse using XML-1.0 before update 5}
  \item{NOBASEFIX}{do not fixup XINCLUDE xml:base uris}
  \item{HUGE}{relax any hardcoded limit from the parser}
  \item{OLDSAX}{parse using SAX2 interface before 2.7.0}
  \item{IGNORE_ENC}{ignore internal document encoding hint}
  \item{BIG_LINES}{Store big lines numbers in text PSVI field}
}}

\item{base_url}{When loading from a connection, raw vector or literal
html/xml, this allows you to specify a base url for the document. Base
urls are used to turn relative urls into absolute urls.}

\item{n}{If \code{file} is a connection, the number of bytes to read per
iteration. Defaults to 64kb.}

\item{verbose}{When reading from a slow connection, this prints some
output on every iteration so you know its working.}
}
\value{
An XML document. HTML is normalised to valid XML - this may not
  be exactly the same transformation performed by the browser, but it's
  a reasonable approximation.
}
\description{
Read HTML or XML.
}
\examples{
# Literal xml/html is useful for small examples
read_xml("<foo><bar /></foo>")
read_html("<html><title>Hi<title></html>")
read_html("<html><title>Hi")

# From a local path
read_html(system.file("extdata", "r-project.html", package = "xml2"))

# From a url
cd <- read_xml("http://www.xmlfiles.com/examples/cd_catalog.xml")
me <- read_html("http://had.co.nz")
}

