% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auto_style.R
\name{auto_style_indent}
\alias{auto_style_indent}
\title{Consolidate the header columns into one, taking the rightmost value and applying indent}
\usage{
auto_style_indent(tab, keyword = "(all)", total_text = NULL,
  left_header_colname = " ")
}
\arguments{
\item{tab}{a tab object}

\item{keyword}{The keyword to use to detect summarisation.  Uses '(all)' by default because this is what reshape2::dcast uses}

\item{total_text}{The text to use for the grand total (a row where all the left headers are '(all)'. Defaults to Grand Total.}

\item{left_header_colname}{The column name of left header column, which is now a single column.}
}
\description{
e.g. a | b | (all) -> b
e.g. (all) | (all) | (all) -> Grand Total
}
\examples{
crosstab <- read.csv(system.file("extdata", "example_crosstab.csv", package="xltabr"))
tab <- initialise()
tab <- add_body(tab, crosstab, left_header_colnames = c("drive", "age"))
tab <- auto_style_indent(tab)
}
