% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/setinfo.xgb.DMatrix.R
\docType{methods}
\name{setinfo}
\alias{setinfo}
\alias{setinfo,xgb.DMatrix-method}
\title{Set information of an xgb.DMatrix object}
\usage{
setinfo(object, ...)

\S4method{setinfo}{xgb.DMatrix}(object, name, info)
}
\arguments{
\item{object}{Object of class "xgb.DMatrix"}

\item{...}{other parameters}

\item{name}{the name of the field to get}

\item{info}{the specific field of information to set}
}
\description{
Set information of an xgb.DMatrix object
}
\details{
It can be one of the following:

\itemize{
    \item \code{label}: label Xgboost learn from ;
    \item \code{weight}: to do a weight rescale ;
    \item \code{base_margin}: base margin is the base prediction Xgboost will boost from ;
    \item \code{group}.
}
}
\examples{
data(agaricus.train, package='xgboost')
train <- agaricus.train
dtrain <- xgb.DMatrix(train$data, label=train$label)
labels <- getinfo(dtrain, 'label')
setinfo(dtrain, 'label', 1-labels)
labels2 <- getinfo(dtrain, 'label')
stopifnot(all(labels2 == 1-labels))
}

