% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sgXGeneMapFactory.R
\name{sgXGeneMapFactory}
\alias{sgXGeneMapFactory}
\title{Factory for configuring a gene dependent geneMap function.}
\usage{
sgXGeneMapFactory(algorithm = "sga", method = "Bin2Dec")
}
\arguments{
\item{algorithm}{Algorithm. 
Available: "sga", "sgde", "sgperm", "sge", sgp". 
Default: "sga".}

\item{method}{The GeneMap method. The choices depend on the 
\code{algorithm}.}
}
\value{
GeneMap function for the selected algorithm from the correct package.
}
\description{
The geneMap function depends on the gene representation and
             the algorithm selected.
}
\details{
Methods available for the different algorithms are:
   \itemize{
    \item "sga": "Bin2Dec", "Gray2Dec", "Identity", "Permutation".
    \item "sgde": "Identity".
    \item "sgperm": "Identity". The gene map function is not used in 
                                the decoder.
    \item "sgp": "Identity". The gene map function is not used in 
                                the decoder.
    \item "sge": "Mod" or "Bucket".
 }
}
\examples{
sgXGeneMapFactory(algorithm="sga", method="Bin2Dec")

}
\seealso{
Other Configuration: 
\code{\link{sgXCrossoverFactory}()},
\code{\link{sgXDecodeGeneFactory}()},
\code{\link{sgXInitGeneFactory}()},
\code{\link{sgXMutationFactory}()},
\code{\link{sgXReplicationFactory}()}
}
\concept{Configuration}
