% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tachyons.R
\name{tachyons}
\alias{tachyons}
\alias{use_tachyons}
\alias{html_dependency_tachyons}
\title{Tachyons}
\usage{
use_tachyons(minified = TRUE)

html_dependency_tachyons(minified = TRUE)
}
\arguments{
\item{minified}{Use the minified Tachyons css file? Default is \code{TRUE}.}
}
\value{
An \code{htmltools::tagList()} with the tachyons dependencies, or an
\code{\link[htmltools:htmlDependency]{htmltools::htmlDependency()}}.
}
\description{
Tachyons is a collection of CSS utility classes that works beautifully with
\pkg{xaringan} presentations using the `remarkjs`` class syntax.
}
\section{Functions}{
\itemize{
\item \code{use_tachyons}: Adds tachyons to your xaringan slides.

\item \code{html_dependency_tachyons}: Returns an \code{\link[htmltools:htmlDependency]{htmltools::htmlDependency()}} with the tile
view dependencies. Most users will want to use \code{use_tachyons()}.
}}

\section{Usage}{
 To add tachyons to your xaringan presentation, add the
following code chunk to your slides' R Markdown file.

\if{html}{\out{<div class="sourceCode markdown">}}\preformatted{```\{r xaringan-tachyons, echo=FALSE\}
xaringanExtra::use_tachyons()
```
}\if{html}{\out{</div>}}

Tachyons provides small, single-purpose CSS classes that are easily composed
to achieve larger functionality and styles. In the \href{https://github.com/gnab/remark/wiki/Markdown#content-classes}{remarkjs content classes syntax}, you
can compose classes by chaining them together. For example, the following
markdown produces a box with a washed green background (\code{.bg-washed-green}),
a dark green border (\code{.b--dark-green}) on all sides (\code{.ba}) with line width
2 (\code{.bw2}) and border radius (\code{.br3}). The box has a shadow (\code{.shadow-5})
and medium-large horizontal padding (\code{.ph4}) with a large top margin
(\code{.mt5}).

\if{html}{\out{<div class="sourceCode markdown">}}\preformatted{.bg-washed-green.b--dark-green.ba.bw2.br3.shadow-5.ph4.mt5[
The only way to write good code is to write tons of bad code first.
Feeling shame about bad code stops you from getting to good code

.tr[
— Hadley Wickham
]]
}\if{html}{\out{</div>}}
}

\examples{
use_tachyons()

}
\references{
\href{http://tachyons.io/}{tachyons},
\href{https://roperzh.github.io/tachyons-cheatsheet/}{Tachyons Cheat Sheet}
}
