% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualize.R
\name{xQTLvisual_locusCombine}
\alias{xQTLvisual_locusCombine}
\title{Generate a combined figure including locuszoom and locuscompare plot object.}
\usage{
xQTLvisual_locusCombine(
  gwasEqtldata,
  posRange = "",
  population = "EUR",
  highlightSnp = "",
  legend_position = "bottomright",
  snpLD = NULL
)
}
\arguments{
\item{gwasEqtldata}{A data.frame or a data.table that including signals from both GWAS and eQTL. Five columns are required (arbitrary column names is supported):

\verb{Col 1}. "snps" (character), using an rsID (e.g. "rs11966562").

\verb{Col 2}. "chromosome" (character), one of the chromosome from chr1-chr22.

\verb{Col 3}. "postion" (integer), genome position of snp.

\verb{Col 4}. "P-value" (numeric) of GWAS signals.

\verb{Col 5}. "P-value" (numeric) of eQTL signals.}

\item{posRange}{Genome range that you want to visualize (e.g. "chr6:3e7-7e7"). Default is the region that covers all snps.}

\item{population}{One of the 5 popuations from 1000 Genomes: 'AFR', 'AMR', 'EAS', 'EUR', and 'SAS'.}

\item{highlightSnp}{Default is the snp that with lowest p-value.}

\item{legend_position}{(string, optional) Either 'bottomright','topright', or 'topleft'. Default: 'bottomright'.}

\item{snpLD}{A data.frame object of LD matrix. Default is null.}
}
\value{
A ggplot object.
}
\description{
This function is rebuilt from \code{locuscompare.R} (https://github.com/boxiangliu/locuscomparer/blob/master/R/locuscompare.R).
}
\examples{
\donttest{
# load data:
u1 <-"https://master.dl.sourceforge.net/project/exampledata/gwas/AD/gwasEqtldata.txt"
gwasEqtldata <- data.table::fread(u1)
xQTLvisual_locusCombine(gwasEqtldata, highlightSnp="rs13120565")
}
}
