% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualize.R
\name{xQTLvisual_enrich}
\alias{xQTLvisual_enrich}
\title{Visualizing enriched variants}
\usage{
xQTLvisual_enrich(enrichHits, pValueBy = 10, plotType = "boxplot")
}
\arguments{
\item{enrichHits}{A data.table object from result of xQTLanno_enrich}

\item{pValueBy}{Cutoff of pvlaue. Defaults: 5}

\item{plotType}{"boxplot", or "density"}
}
\value{
A ggplot object
}
\description{
Visualizing enriched variants
}
\examples{
\donttest{
url1 <- "http://github.com/dingruofan/exampleData/raw/master/gwas/gwasSub.txt.gz"
snpInfo <- fread(url1, sep="\t")
enrichHits <- xQTLanno_enrich(snpInfo, enrichElement="TF")
xQTLvisual_enrich(enrichHits, plotType="density")
}
}
