% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getCensusData.R
\name{censusData}
\alias{censusData}
\title{Census Data download function.}
\usage{
censusData(key, state, geo = "tract", demo = FALSE)
}
\arguments{
\item{key}{A required character object. Must contain user's Census API
key, which can be requested \href{http://api.census.gov/data/key_signup.html}{here}.}

\item{state}{to extract Census data for, e.g. \code{"NJ"}.}

\item{geo}{A character object specifying what aggregation level to use. 
Use \code{"county"}, \code{"tract"}, or \code{"block"}. Default is \code{"tract"}. 
Warning: extracting block-level data takes very long.}

\item{demo}{A \code{TRUE}/\code{FALSE} object indicating whether to condition on 
demographics (i.e., age and sex) or not. If \code{TRUE}, function will return 
Pr(Geolocation, Age, Sex | Race). If \code{FALSE}, function wil return 
Pr(Geolocation | Race). Default is \code{FALSE}.}
}
\value{
Output will be an object of class \code{list}, indexed by state names. It will 
 consist of the original user-input data with additional columns of 
 Census data.
}
\description{
\code{censusData} retrieve Census data.
}
\details{
This function allows users to download (e.g., voter file) the U.S. Census 2010 data, 
at either county level, tract level or block level.
}
\examples{
\dontshow{data(voters)}
\dontrun{censusData(key = "...", states = c("NJ", "DE"), geo = "block")}
\dontrun{censusData(key = "...", states = "FL", geo = "tract", 
demo = TRUE)}

}
\references{
Relies on getCensusApi, getCensusApi2, and vecToChunk functions authored by Nicholas Nagle, 
available \href{http://rstudio-pubs-static.s3.amazonaws.com/19337_2e7f827190514c569ea136db788ce850.html}{here}.
}

