% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bpipe.R
\name{\%.>\%}
\alias{\%.>\%}
\title{Pipe operator ("dot arrow").}
\usage{
pipe_left_arg \%.>\% pipe_right_arg
}
\arguments{
\item{pipe_left_arg}{left argument expression (substituted into .)}

\item{pipe_right_arg}{right argument expession (presumably including .)}
}
\value{
eval(\{ . <- pipe_left_arg; pipe_right_arg \};)
}
\description{
Defined as roughly : \code{a \%>.\% b} ~ \code{\{ . <- a; b \};}
(with visible .-side effects).
}
\details{
The pipe operator has a couple of special cases. First: if the right hand side is a name,
then we try to de-reference it.  Second: if the right-hand side includes the class decleration
"wrapr_applicable" and has a field named "wrapr_applicable" that is a function, then
we apply this function to the first and second arguments of the pipe.
}
\examples{

# both should be equal:
cos(exp(sin(4)))
4 \%.>\% sin(.) \%.>\% exp(.) \%.>\% cos(.)

}
