% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pairsAsPropensMatr.R
\name{pairsAsPropensMatr}
\alias{pairsAsPropensMatr}
\title{Convert pairs of node-names to propensity matrix (non-oriented)
 
This function allows converting pairs of node-names to a propensity matrix (non-oriented).}
\usage{
pairsAsPropensMatr(mat, silent = FALSE, callFrom = NULL)
}
\arguments{
\item{mat}{(matrix or data.frame, 2 columns) main input, pairs of nodes describing one edge per line}

\item{silent}{(logical) suppress messages}

\item{callFrom}{(character) allows easier tracking of message(s) produced}
}
\value{
(symmetrix) matrix with numeric content based on counting occurances a given node has edges conected to it
}
\description{
Convert pairs of node-names to propensity matrix (non-oriented)
 
This function allows converting pairs of node-names to a propensity matrix (non-oriented).
}
\examples{
pairs3L <- matrix(LETTERS[c(1,3,3, 2,2,1)], ncol=2)      # loop of 3
(netw13pr <- pairsAsPropensMatr(pairs3L))   # as prop matr

}
\seealso{
in \code{\link[base]{cbind}}
}
