% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/show_metseason.R
\name{show_metseason}
\alias{show_metseason}
\title{Plot period (seasonal) averages from fitted GAM}
\usage{
show_metseason(
  mod,
  metfun = mean,
  doystr = 1,
  doyend = 364,
  yrstr = 2000,
  yrend = 2019,
  yromit = NULL,
  ylab,
  width = 0.9,
  size = 1.5,
  nsim = 10000,
  useave = FALSE,
  base_size = 11,
  xlim = NULL,
  ylim = NULL,
  ...
)
}
\arguments{
\item{mod}{input model object as returned by \code{\link{anlz_gam}}}

\item{metfun}{function input for metric to calculate, e.g., \code{mean}, \code{var}, \code{max}, etc}

\item{doystr}{numeric indicating start Julian day for extracting averages}

\item{doyend}{numeric indicating ending Julian day for extracting averages}

\item{yrstr}{numeric for starting year for trend model, see details}

\item{yrend}{numeric for ending year for trend model, see details}

\item{yromit}{optional numeric vector for years to omit from the plot, see details}

\item{ylab}{chr string for y-axis label}

\item{width}{numeric for width of error bars}

\item{size}{numeric for point size}

\item{nsim}{numeric indicating number of random draws for simulating uncertainty}

\item{useave}{logical indicating if \code{\link{anlz_avgseason}} is used for the seasonal metric calculation, see details}

\item{base_size}{numeric indicating base font size, passed to \code{\link[ggplot2]{theme_bw}}}

\item{xlim}{optional numeric vector of length two for x-axis limits}

\item{ylim}{optional numeric vector of length two for y-axis limits}

\item{...}{additional arguments passed to \code{metfun}, e.g., \code{na.rm = TRUE}}
}
\value{
A \code{\link[ggplot2]{ggplot}} object
}
\description{
Plot period (seasonal) averages from fitted GAM
}
\details{
Setting \code{yrstr} or \code{yrend} to \code{NULL} will suppress plotting of the trend line for the meta-analysis regression model.

The optional \code{yromit} vector can be used to omit years from the plot and trend assessment. This may be preferred if seasonal estimates for a given year have very wide confidence intervals likely due to limited data, which can skew the trend assessments.

Set \code{useave = T} to speed up calculations if \code{metfun = mean}.  This will use \code{\link{anlz_avgseason}} to estimate the seasonal summary metrics using a non-stochastic equation.
}
\examples{
library(dplyr)

# data to model
tomod <- rawdat \%>\%
  filter(station \%in\% 34) \%>\%
  filter(param \%in\% 'chl') \%>\% 
  filter(yr > 2015)
  
mod <- anlz_gam(tomod, trans = 'ident')

show_metseason(mod, doystr = 90, doyend = 180, yrstr = 2016, yrend = 2019, 
     ylab = 'Chlorophyll-a (ug/L)')

\donttest{
# show seasonal metrics without annual trend
show_metseason(mod, doystr = 90, doyend = 180, yrstr = NULL, yrend = NULL, 
     ylab = 'Chlorophyll-a (ug/L)')
     
# omit years from the analysis
show_metseason(mod, doystr = 90, doyend = 180, yrstr = 2016, yrend = 2019,
     yromit = 2017, ylab = 'Chlorophyll-a (ug/L)')
}      
}
\concept{show}
