% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wflow_git_remote.R
\name{wflow_git_remote}
\alias{wflow_git_remote}
\title{Manage remote Git repositories}
\usage{
wflow_git_remote(remote = NULL, user = NULL, repo = NULL,
  protocol = "https", action = "add", verbose = TRUE, project = ".")
}
\arguments{
\item{remote}{character (default: NULL). The name of the remote.}

\item{user}{character (default: NULL). The GitHub username for the remote
repository.}

\item{repo}{character (default: NULL). The name of the remote repository on
GitHub.}

\item{protocol}{character (default: "https"). The protocol for communicating
with GitHub. Must be either "https" or "ssh".}

\item{action}{character (default: "add"). The action to perform on the
remotes. Must be one of "add", "remove", or "set_url". This argument is
ignored if \code{remote = NULL}.}

\item{verbose}{logical (default: TRUE). Display the current remotes.
Analogous to \code{git remote -v}.}

\item{project}{character (default: ".") By default the function assumes the
current working directory is within the project. If this is not true,
you'll need to provide the path to the project directory.}
}
\value{
Invisibly returns a named character vector of the remote URLs.
}
\description{
\code{wflow_git_remote} is a convenience function for managing remote
repositories from R. By default is displays the current remote repositories
(analogous to \code{git remote -v}). It can add a remote, remove a remote, or
update the URL for an existing remote.
}
\details{
\code{wflow_git_remote} constructs a URL to a remote GitHub repository based on
the input GitHub username, GitHub repository name, and protocol (https or
ssh). It can add a remote (\code{action = "add"}), remove a remote
(\code{action = "remove"}), or update the URL for an existing remote
(\code{action = "set_url"}).

This function cannot change the name of an existing remote. To accomplish
this, you could run Git from the command line (\code{git remote rename <old>
<new>}) or use \code{git2r::remote_rename} from R.
}
\examples{
\dontrun{
# Display the current remotes
wflow_git_remote()
# Add a remote called origin that points to the
# GitHub repository example_repo owned by
# the GitHub user example_user
wflow_git_remote("origin", "example_user", "example_repo")
# Remove the remote named upstream
wflow_git_remote("upstream", action = "remove")
# Change the protocol of the remote origin from https to ssh
wflow_git_remote("origin", "example_user", "example_repo", protocol = "ssh",
              action = "set_url")
}
}
