% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/delete-wp-pages.R
\name{delete_wp_page}
\alias{delete_wp_page}
\title{Delete a WordPress Page}
\usage{
delete_wp_page(root_url, user, pass, page_id, verbose = TRUE)
}
\arguments{
\item{root_url}{The domain on which you wish to delete the page.}

\item{user}{The username to be passed into the API call to delete the page.}

\item{pass}{The password to be used in the API call to delete the page.
To get this value, you must have the Application Passwords plugin
installed, and must create an application using that plugin via your
WordPress admin panel; there you will get the password needed.}

\item{page_id}{The ID in the WordPress database of the page to be deleted. You can obtain IDs
by using the get_wp_pages() function.}

\item{verbose}{If TRUE, the page id will be printed to the console. Potentially useful
for usage in a single-threaded loop.}
}
\value{
response from the API as a list object. Look for the key "deleted" within the list
to confirm the post was deleted.
}
\description{
Delete a page on your WordPress site using your WordPress site's API.
}
\examples{
\dontrun{
delete_wp_tag(root_url = 'https://domain.com',user = Sys.getenv('username'),
pass = Sys.getenv('password'),page_id = 12)
}

}
