% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mathpnl.R
\docType{data}
\name{mathpnl}
\alias{mathpnl}
\title{mathpnl}
\format{A data.frame with 3850 observations on 52 variables:
\itemize{
 \item \strong{distid:} district identifier
 \item \strong{intid:} intermediate school district
 \item \strong{lunch:} percent eligible for free lunch
 \item \strong{enrol:} school enrollment
 \item \strong{ptr:} pupil/teacher: 1995-98
 \item \strong{found:} foundation grant, $:  1995-98
 \item \strong{expp:} expenditure per pupil
 \item \strong{revpp:} revenue per pupil
 \item \strong{avgsal:} average teacher salary
 \item \strong{drop:} high school dropout rate, percent
 \item \strong{grad:} high school grad. rate, percent
 \item \strong{math4:} percent satisfactory, 4th grade math
 \item \strong{math7:} percent satisfactory, 7th grade math
 \item \strong{choice:} number choice students
 \item \strong{psa:} # public school academy studs.
 \item \strong{year:} 1992-1998
 \item \strong{staff:} staff per 1000 students
 \item \strong{avgben:} avg teacher fringe benefits
 \item \strong{y92:} =1 if year == 1992
 \item \strong{y93:} =1 if year == 1993
 \item \strong{y94:} =1 if year == 1994
 \item \strong{y95:} =1 if year == 1995
 \item \strong{y96:} =1 if year == 1996
 \item \strong{y97:} =1 if year == 1997
 \item \strong{y98:} =1 if year == 1998
 \item \strong{lexpp:} log(expp)
 \item \strong{lfound:} log(found)
 \item \strong{lexpp_1:} lexpp[_n-1]
 \item \strong{lfnd_1:} lfnd[_n-1]
 \item \strong{lenrol:} log(enrol)
 \item \strong{lenrolsq:} lenrol^2
 \item \strong{lunchsq:} lunch^2
 \item \strong{lfndsq:} lfnd^2
 \item \strong{math4_1:} math4[_n-1]
 \item \strong{cmath4:} math4 - math4_1
 \item \strong{gexpp:} lexpp - lexpp_1
 \item \strong{gexpp_1:} gexpp[_n-1
 \item \strong{gfound:} lfound - lfnd_1
 \item \strong{gfnd_1:} gfound[_n-1]
 \item \strong{clunch:} lunch - lunch[_n-1]
 \item \strong{clnchsq:} lunchsq - lunchsq[_n-1]
 \item \strong{genrol:} lenrol - lenrol[_n-1]
 \item \strong{genrolsq:} genrol^2
 \item \strong{expp92:} expp in 1992
 \item \strong{lexpp92:} log(expp92)
 \item \strong{math4_92:} math4 in 1992
 \item \strong{cpi:} consumer price index
 \item \strong{rexpp:} real spending per pupil, 1997$
 \item \strong{lrexpp:} log(rexpp)
 \item \strong{lrexpp_1:} lrexpp[_n-1]
 \item \strong{grexpp:} lrexpp - lrexpp_1
 \item \strong{grexpp_1:} grexpp[_n-1]
}}
\source{
\url{https://www.cengage.com/cgi-wadsworth/course_products_wp.pl?fid=M20b&product_isbn_issn=9781111531041}
}
\usage{
data('mathpnl')
}
\description{
Wooldridge Source: Leslie Papke, an economics professor at MSU, collected these data from Michigan Department of Education web site, www.michigan.gov/mde. These are district-level data, which Professor Papke kindly provided. She has used building-level data in “The Effects of Spending on Test Pass Rates: Evidence from Michigan” (2005), Journal of Public Economics 89, 821-839. Data loads lazily.
}
\section{Used in Text}{
 pages 479-480, 505-506
}

\examples{
 str(mathpnl)
}
\keyword{datasets}
