% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visibility.R
\name{getISO3}
\alias{getISO3}
\title{getISO3}
\usage{
getISO3(
  pp,
  crs_pp = 4326,
  col = "ISO3",
  resol = "low",
  coords = c("LONG", "LAT"),
  ask = FALSE
)
}
\arguments{
\item{pp}{Simple Feature Points or coordinate matrix/data.frame}

\item{crs_pp}{The CRS of the points}

\item{col}{Which column/s should be returned}

\item{resol}{The search resolution. The options are "coarse","low",
"less islands","li","high". For "high" you need to install the 
package \code{rworldxtra}}

\item{coords}{The column names of the point matrix}

\item{ask}{A boolean, to ask which columns can be returned}
}
\value{
A character vector
}
\description{
Get point values from the \code{\link[rworldmap]{getMap}}
}
\examples{
\dontrun{
library(sf)
points = cbind(c(4488182.26267016, 4488852.91748256), 
               c(2667398.93118627, 2667398.93118627))
getISO3(pp = points, ask = TRUE, crs_pp = 3035)

points <- as.data.frame(points)
colnames(points) <- c("x","y")
points <- st_as_sf(points, coords = c("x","y"))
st_crs(points) <- 3035
getISO3(pp = points, crs_pp = 3035)
}
}
\seealso{
Other Helper Functions: 
\code{\link{dup_coords}()},
\code{\link{getDEM}()},
\code{\link{get_grids}()},
\code{\link{grid_area}()},
\code{\link{hexa_area}()},
\code{\link{isSpatial}()},
\code{\link{permutations}()},
\code{\link{readintegerSel}()},
\code{\link{readinteger}()},
\code{\link{splitAt}()},
\code{\link{windata_format}()}
}
\concept{Helper Functions}
