% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HexaTex.R
\name{HexaTex}
\alias{HexaTex}
\title{Polygon to Hexagonal Grid Tessellation}
\usage{
HexaTex(Polygon1, size, plotTrue = FALSE)
}
\arguments{
\item{Polygon1}{The SpatialPolygons object (SpatialPolygons)}

\item{size}{The side length of an hexagon (numeric)}

\item{plotTrue}{Should the object be plotted (logical)}
}
\value{
Returns a list with an indexed data frame of the point coordinates
and a SpatialPolygons object of the hexagons (list)
}
\description{
The function takes a Polygon and a sizing argument and
creates a list with an indexed data frame with coordinates
and a SpatialPolygons object, that consists of hexagonal grid cells.
}
\examples{
library(spatstat)
library(maptools)
library(sp)
Polygon1 <- Polygon(rbind(c(4498482, 2668272), c(4498482, 2669343),
                          c(4499991, 2669343), c(4499991, 2668272)))
Polygon1 <- Polygons(list(Polygon1),1);
Polygon1 <- SpatialPolygons(list(Polygon1))
Projection <- "+proj=laea +lat_0=52 +lon_0=10 +x_0=4321000 +y_0=3210000
+ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs"
proj4string(Polygon1) <- CRS(Projection)
plot(Polygon1,axes=TRUE)
HexGrid <- HexaTex(Polygon1, 100, TRUE)
plot(HexGrid[[2]])
str(HexGrid[[1]])

}
\author{
Sebastian Gatscha
}
