% Generated by roxygen2 (4.0.1): do not edit by hand
\name{GetSimultaneous}
\alias{GetSimultaneous}
\title{Identify simultaneous fixes between trajectories}
\usage{
GetSimultaneous(traj1, traj2, tc = 0)
}
\arguments{
\item{traj1}{an object of the class \code{ltraj} which contains the time-stamped
movement fixes of the first object. Note this object must be a \code{type II
ltraj} object. For more information on objects of this type see \code{help(ltraj)}.}

\item{traj2}{same as \code{traj1}.}

\item{tc}{time threshold for determining simultaneous fixes. For simplicity, \code{tc}
   is always taken in seconds.}
}
\value{
A single ltraj object containing two bursts, representing the two original \code{ltraj}
objects, each containing only those fixes that are deemed simultaneous.
}
\description{
The function \code{GetSimultaneous} identifies and extracts simultaneous fixes,
  within a given tolerance limit, between two movement datasets.
}
\details{
This function is used to determine the simultaneous fixes between two movement
  datasets facilitating further analysis.
}
\examples{
data(deer)
deer37 <- deer[1]
deer38 <- deer[2]
#tc = 7.5 minutes
trajs <- GetSimultaneous(deer37, deer38, tc = 7.5*60)
deer37 <- trajs[1]
deer38 <- trajs[2]
}
\seealso{
as.ltraj
}
\keyword{processing}

