% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wiki_utils.R
\name{w_OccupationEntities}
\alias{w_OccupationEntities}
\title{Gets Wikidata entities with a certain occupation}
\usage{
w_OccupationEntities(
  Qoc,
  nlimit = NULL,
  mode = c("default", "count", "wikipedias")
)
}
\arguments{
\item{Qoc}{The Wikidata entity of the occupation. For example, Q2306091
sociologist, Q2526255 Film director, etc.}

\item{nlimit}{If the number of entities found with that occupation exceeds
this number, chunked queries are done. This is the number of entities requested
in each chunk. No effects in mode='count'. (default=10000, 5000 if mode='wikipedias')}

\item{mode}{The results you want to obtain: 'default' returns the Wikidata
entities which have the occupation indicated; 'count' search in WDQS to know
the number of Wikidata entities with P106 property (occupation) set to Qoc;
'wikipedias' returns the Wikidata entities which have the occupation
indicated in Qoc, plus the Wikipedia page titles of them.
Note that mode='wikipedias' is similar to first launch w_OccupationEntities
and then launch w_Wikipedias, but is more efficient. (default='default')}
}
\value{
A vector with the Wikidata entities with that occupation by default;
if mode='count' the number of entities with that occupation (integer);
if mode='wikipedias' a data-frame with Wikidata entities, the number of
Wikipedias in which they have page, the Wikipedia languages, the page titles,
and finally, the URL to the pages. Last three columns concatenated with "|".
Return all Wikipedias pages, not limited by languages.
}
\description{
Returns the Wikidata entities which have the occupation indicated in Qoc, the
Wikidata entity for that occupation. Use chunked requests.
}
\examples{
w_OccupationEntities(Qoc='Q2306091', mode='count') # Qoc for Sociologist
l <- w_OccupationEntities(Qoc='Q2306091')
\dontrun{
lw <- w_OccupationEntities(Qoc='Q2306091', mode='wikipedias')
}
}
\author{
Angel Zazo, Department of Computer Science and Automatics, University of Salamanca
}
