% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wikiTools.R
\name{nametoWikiHtml}
\alias{nametoWikiHtml}
\title{Create the Wikipedia link of a name or entry.}
\usage{
nametoWikiHtml(name, language = "en")
}
\arguments{
\item{name}{A vector consisting of one or more Wikipedia's entry (i.e., topic or person).}

\item{language}{The language of the Wikipedia page version. This should consist of an ISO language code (default = "en").}
}
\value{
A character vector of names' links.
}
\description{
Create the Wikipedia link of a name or entry.
}
\details{
This function adds the Wikipedia's html link to a entry or name, i.e., "Max Weber" converts into "\verb{<a href='https://es.wikipedia.org/wiki/Max_Weber' target='_blank'>Max Weber</a>}". It also manages different the languages of Wikipedia through the abbreviated two-letter language parameter, i.e., "en" = "english".
}
\examples{
## When extracting a single item;
nametoWikiHtml("Computer", language = "en")

## When extracting two objetcs;
A <- c("Computer", "Operating system")
nametoWikiHtml(A)
B <- c("Socrates", "Plato","Aristotle" )
nametoWikiHtml(B)
}
\author{
Modesto Escobar, Department of Sociology and Communication, University of Salamanca. See \url{https://sociocav.usal.es/blog/modesto-escobar/}
}
