% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hydro_analysis.R
\name{wbt_breach_depressions_least_cost}
\alias{wbt_breach_depressions_least_cost}
\title{Breach depressions least cost}
\usage{
wbt_breach_depressions_least_cost(
  dem,
  output,
  dist,
  max_cost = NULL,
  min_dist = TRUE,
  flat_increment = NULL,
  fill = TRUE,
  wd = NULL,
  verbose_mode = NULL,
  compress_rasters = NULL,
  command_only = FALSE
)
}
\arguments{
\item{dem}{Input raster DEM file.}

\item{output}{Output raster file.}

\item{dist}{Maximum search distance for breach paths in cells.}

\item{max_cost}{Optional maximum breach cost (default is Inf).}

\item{min_dist}{Optional flag indicating whether to minimize breach distances.}

\item{flat_increment}{Optional elevation increment applied to flat areas.}

\item{fill}{Optional flag indicating whether to fill any remaining unbreached depressions.}

\item{wd}{Changes the working directory. Default: \code{NULL} will use the value in WhiteboxTools settings, see \code{wbt_wd()} for details.}

\item{verbose_mode}{Sets verbose mode. If verbose mode is \code{FALSE}, tools will not print output messages. Default: \code{NULL} will use the value in WhiteboxTools settings, see \code{wbt_verbose()} for details.}

\item{compress_rasters}{Sets the flag used by 'WhiteboxTools' to determine whether to use compression for output rasters. Default: \code{NULL} will use the value in WhiteboxTools settings, see \code{wbt_compress_rasters()} for details.}

\item{command_only}{Return command that would be executed by \code{system()} rather than running tool. Default: \code{FALSE}.}
}
\value{
Returns the tool text outputs.
}
\description{
Breaches the depressions in a DEM using a least-cost pathway method.
}
\keyword{HydrologicalAnalysis}
