% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/image_analysis_enhancement.R
\name{wbt_direct_decorrelation_stretch}
\alias{wbt_direct_decorrelation_stretch}
\title{Direct decorrelation stretch}
\usage{
wbt_direct_decorrelation_stretch(
  input,
  output,
  k = 0.5,
  clip = 1,
  wd = NULL,
  verbose_mode = FALSE,
  compress_rasters = FALSE,
  command_only = FALSE
)
}
\arguments{
\item{input}{Input colour composite image file.}

\item{output}{Output raster file.}

\item{k}{Achromatic factor (k) ranges between 0 (no effect) and 1 (full saturation stretch), although typical values range from 0.3 to 0.7.}

\item{clip}{Optional percent to clip the upper tail by during the stretch.}

\item{wd}{Changes the working directory.}

\item{verbose_mode}{Sets verbose mode. If verbose mode is \code{FALSE}, tools will not print output messages.}

\item{compress_rasters}{Sets the flag used by 'WhiteboxTools' to determine whether to use compression for output rasters.}

\item{command_only}{Return command that would be executed by \code{system()} rather than running tool.}
}
\value{
Returns the tool text outputs.
}
\description{
Performs a direct decorrelation stretch enhancement on a colour-composite image of multispectral data.
}
\keyword{ImageProcessingToolsImageEnhancement}
