% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/terrain_analysis.R
\name{wbt_feature_preserving_smoothing}
\alias{wbt_feature_preserving_smoothing}
\title{Feature preserving smoothing}
\usage{
wbt_feature_preserving_smoothing(
  dem,
  output,
  filter = 11,
  norm_diff = 15,
  num_iter = 3,
  max_diff = 0.5,
  zfactor = NULL,
  wd = NULL,
  verbose_mode = FALSE,
  compress_rasters = FALSE
)
}
\arguments{
\item{dem}{Input raster DEM file.}

\item{output}{Output raster file.}

\item{filter}{Size of the filter kernel.}

\item{norm_diff}{Maximum difference in normal vectors, in degrees.}

\item{num_iter}{Number of iterations.}

\item{max_diff}{Maximum allowable absolute elevation change (optional).}

\item{zfactor}{Optional multiplier for when the vertical and horizontal units are not the same.}

\item{wd}{Changes the working directory.}

\item{verbose_mode}{Sets verbose mode. If verbose mode is False, tools will not print output messages.}

\item{compress_rasters}{Sets the flag used by WhiteboxTools to determine whether to use compression for output rasters.}
}
\value{
Returns the tool text outputs.
}
\description{
Reduces short-scale variation in an input DEM using a modified Sun et al. (2007) algorithm.
}
