% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wbt.R
\name{wbt_run_tool}
\alias{wbt_run_tool}
\title{Run a tool.}
\usage{
wbt_run_tool(tool_name, args, verbose_mode = FALSE)
}
\arguments{
\item{tool_name}{The name of the tool to run.}

\item{args}{Tool arguments.}

\item{verbose_mode}{Verbose mode. Without this flag, tool outputs will not be printed.}
}
\value{
Returns the output descriptions of the tool.
}
\description{
Runs a tool and specifies tool arguments.
}
\examples{
tool_name <- "breach_depressions"
dem <- system.file("extdata", "DEM.tif", package="whitebox")
output <- "./output.tif"
arg1 <- paste0("--dem=", dem)
arg2 <- paste0("--output=", output)
args <- paste(arg1, arg2)
wbt_run_tool(tool_name, args)
}
