\name{IsInWake}
\alias{IsInWake}

\title{For a given range of two angles, checks whether a given wind direction is within that range.}

\description{
Provided a range of two angles and a third angle, checks whether that third angle is within the given range. In the Jensen wake model, looking from one turbine's location at another turbine's location, this can be used to check whether a wind direction is within the 'wake cone' created by the first turbine. In effect, this function checks whether a turbine is located in the wake of another turbine, based on a given wind direction.
}

\usage{
IsInWake(Cone, Direction)
}

\arguments{
	\item{Cone}{
		must be a vector of two. Contains degree information concerning the Jensen 'wake cone' generated by the first turbine.
	}
	\item{Direction}{
		must be a single value. Contains the wind direction to check whether Jensen's wake model must be computed for a pair of turbines.
	}
}

\value{
\code{IsInWake} returns \code{TRUE}, if \code{Direction} is within \code{Cone}, or \code{FALSE}, else.
}

\references{
Jensen, N. O. (1983). A note on wind generator interaction. Roskilde: Risø National Laboratory. Risø-M, No. 2411
}

\author{
Carsten Croonenbroeck
}

\seealso{
\code{\link{JensenAngle}} to compute 'cone' angle information.
}

\examples{
IsInWake(c(25, 35), 30)
## Returns TRUE.
IsInWake(c(25, 35), 70)
## Returns FALSE.
}

\keyword{Jensen}
\keyword{Profit}
