\name{Ops}
\alias{Ops}
\alias{Ops.weyl}
\alias{weyl_prod}
\alias{weyl_prod_helper1}
\alias{weyl_prod_helper2}
\alias{weyl_prod_helper3}
\alias{weyl_prod_univariate_onerow}
\alias{weyl_prod_univariate_nrow}
\alias{weyl_prod_multivariate_onerow_singlecolumn}
\alias{weyl_prod_multivariate_onerow_allcolumns}
\alias{weyl_prod_multivariate_nrow_allcolumns}
\alias{weyl_power_scalar}
\alias{prodfunc}
\title{Arithmetic Ops Group Methods for the Weyl algebra}
\description{\loadmathjax
  Allows arithmetic operators to be used for spray calculations, 
  such as addition, multiplication, division, integer powers, etc.

  Idiom such as \code{x^2 + y*z/5} should work as expected.  Operations
  are the same as those of the \pkg{spray} package except for \code{*},
  which is interpreted as functional composition.  A number of helper
  functions are documented here (which are not designed for the
  end-user).
}
\usage{
\method{Ops}{weyl}(e1, e2 = NULL)
weyl_prod_helper1(a,b,c,d)
weyl_prod_helper2(a,b,c,d)
weyl_prod_helper3(a,b,c,d)
weyl_prod_univariate_onerow(S1,S2,func)
weyl_prod_univariate_nrow(S1,S2)
weyl_prod_multivariate_onerow_singlecolumn(S1,S2,column)
weyl_prod_multivariate_onerow_allcolumns(S1,S2)
weyl_prod_multivariate_nrow_allcolumns(S1,S2)
weyl_power_scalar(S,n)
}
\arguments{
  \item{S,S1,S2,e1,e2}{Objects of class \code{weyl}, elements of a Weyl
    algebra}
  \item{a,b,c,d}{Integers, see details}
  \item{column}{column to be multiplied}
  \item{n}{Integer power (non-negative)}
  \item{func}{Function used for products}
}
\details{

All arithmetic is as for \code{spray} objects, apart from \code{*} and
\code{^}.  Here, \code{*} is interpreted as operator concatenation:
Thus, if \mjseqn{w_1} and \mjseqn{w_2} are Weyl objects, then
\mjeqn{w_1w_2}{w_1 w_2} is defined as the operator that takes \mjseqn{f}
to \mjeqn{w_1(w_2f)}{w_1(w_2(f))}.

Functions such as \code{weyl_prod_multivariate_nrow_allcolumns()} are
low-level helper functions with self-explanatory names.  In this
context, \dQuote{\code{univariate}} means the first Weyl algebra,
generated by \mjeqn{\left\lbrace x,\partial\right\rbrace}{omitted},
subject to \mjeqn{x\partial-\partial x=1}{omitted}; and
\dQuote{\code{multivariate}} means the algebra generated by
\mjeqn{\left\lbrace
x_1,x_2,\ldots,x_n,\partial_{x_1},\partial_{x_2},\ldots,\partial_{x_n}\right\rbrace}{omitted}.

The product is somewhat user-customisable via option \code{prodfunc},
which affects function \code{weyl_prod_univariate_onerow()}.  Currently
the package offers three examples: \code{weyl_prod_helper1()},
\code{weyl_prod_helper2()}, and \code{weyl_prod_helper3()}.  These are
algebraically identical but occupy different positions on the
efficiency-readability scale.  The option defaults to
\code{weyl_prod_helper3()}, which is the fastest but most opaque.  The
vignette provides further details, motivation, and examples.

}
\value{Generally, return a weyl object}
\author{Robin K. S. Hankin}

\note{Function \code{weyl_prod_univariate_nrow()} is present for
  completeness, it is not used in the package}
\examples{
x <- rweyl(n=1,d=2)
y <- rweyl(n=1,d=2)
z <- rweyl(n=2,d=2)


x*(y+z) == x*y + x*z
is.zero(x*(y*z) - (x*y)*z)

}
