% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/weightTAPSoutput.R
\docType{methods}
\name{weightTAPSoutput-class}
\alias{getattrit}
\alias{getattrit,weightTAPSoutput-method}
\alias{getdf}
\alias{getdf,weightTAPSoutput-method}
\alias{getstats}
\alias{getstats,weightTAPSoutput-method}
\alias{initialize,weightTAPS-method}
\alias{plot,weightTAPSoutput-method}
\alias{print,weightTAPSoutput-method}
\alias{show,weightTAPSoutput-method}
\alias{weightTAPSoutput}
\alias{weightTAPSoutput-class}
\title{An object outputted by weightTAPS function}
\description{
Objects of class \code{weightTAPSoutput} are created by the \code{weightTAPS} function
}
\details{
An object of the class `weightTAPSoutput' has the following slots:
\itemize{
\item \code{df} List of dataframes of subsetted TAPS data with imputed data for non-response in covariates, with column for weights - if method none chosen, of class data.frame
\item \code{attrit} A list of vectors of attrition rates by sociodemographic groups
\item \code{stats} A list of population statistics from wave to wave
}

The slot \code{df} contains the dataframe(s) that represent the final subset data.
The final subset data keeps only the outcome and covariates of interest specified. It also accounts for non-response in the outcome variable and attrition.
Respondents with missing values in the outcome variable for any of the waves desired are removed from the final dataframe.
Missing values in sociodemographic variables are imputed for the respondents that remain in the sample, in order to compute their proper weight.
The missing covariate data can be left as is, by specifying \code{method="none"}.
If imputation is desired, the argument \code{method} can be set to 'multi' for multiple imputation, or 'hotdeck' for hotdeck imputation.
If multiple imputation is done, the argument \code{m} should be set to the number of imputed dataframes to be created.


The slot \code{attrit} is a list of attrition rates from the first wave specified in the outcome argument.
Each quantity represents the percentage of people (by demographic group) that attritted TAPS through the waves specified.
It compares the initial composition of each demographic group (from the oldest wave specified) to the composition of the same demographic group in the final subset data delivered by \code{weightTAPS()}.
Large values, particularly large values relative to other values in the same sociodemographic category, indicate high rates of attrition.


The slot \code{stats} lists each sociodemographic group's share of the overall population as represented in the final sample for each outcome.
The information contained in both the \code{attrit} and \code{stats} slots can be graphically illustrated using the \code{plot(objectname)} function.
Two different types of plots are displayed after running the plot function: a dot chart and a set of trend plots.
The dot chart shows the differences between the sociodemographic composition of the sample in the first wave specified and the final subset dataframe.
This information is disaggregated by the following sociodemographic groups: Age and Gender, Ethnicity, Education, Income, Region and Metropolitan status, and Internet use.
The trend plots presented illustrate the changing composition of the sample by demographic group across the waves specified.
The lines shown in each plot correspond to the different categories within each of the groups mentioned.
The lines show the percentage of the final subset data belonging to each category by wave.
The plots aim to show the variation in the composition of the sociodemographic groups through the waves specified.


\code{print(objectname)} will show a summary of the attrition rates.
\code{show(objectname)} will run the \code{print} function.
}
\author{
David Carlson \email{carlson.david@wustl.edu},  Michelle Torres \email{smtorres@wustl}, and Taeyong Park \email{t.park@wustl.edu}
}
\seealso{
\code{\link{weightTAPSPACK}} \code{\link{weightTAPS}} \code{\link{variablesTAPS}} \code{\link{subsetTAPS}} \code{\link{wavesTAPS}} \code{\link{simpleWeight}} \code{\link{attritTAPS}} \code{\link{multipleImp}} \code{\link{hotdeckImp}} \code{\link{wavesTAPS}}
}

