% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parameter_estimators.R
\encoding{UTF-8}
\name{loglik_function}
\alias{loglik_function}
\title{Log-Likelihood Function for (Log-) Location-Scale Distributions (with Threshold)}
\usage{
loglik_function(x, event, wts = rep(1, length(x)), pars,
  distribution = c("weibull", "lognormal", "loglogistic", "normal",
  "logistic", "sev", "weibull3", "lognormal3", "loglogistic3"))
}
\arguments{
\item{x}{a numeric vector which consists of lifetime data. Lifetime
data could be every characteristic influencing the reliability of a product,
e.g. operating time (days/months in service), mileage (km, miles), load
cycles.}

\item{event}{a vector of binary data (0 or 1) indicating whether unit \emph{i}
is a right censored observation (= 0) or a failure (= 1).}

\item{wts}{optional vector of case weights. The length of \code{wts} must be the
same as the number of observations \code{x}. Default is that \code{wts} is a
vector with all components being 1 (same weights).}

\item{pars}{a numeric vector of parameters. The first element is the location
parameter (\eqn{\mu}), the second is the scale parameter (\eqn{\sigma}) and if
a three-parametric model is used the third element is the threshold parameter
(\eqn{\gamma}).}

\item{distribution}{supposed distribution of the random variable. The
value can be \code{"weibull"}, \code{"lognormal"}, \code{"loglogistic"},
\code{"normal"}, \code{"logistic"}, \code{"sev"} \emph{(smallest extreme value)},
\code{"weibull3"}, \code{"lognormal3"} or \code{"loglogistic3"}.
Other distributions have not been implemented yet.}
}
\description{
This function computes the log-likelihood value with respect to a given set
of parameters. For two-parametric models the location and scale parameters
are required. If a three-parametric lifetime distribution is needed an
additional threshold parameter is required. In terms of
\emph{Maximum Likelihood Estimation} this function can be optimized (\code{\link{optim}})
to estimate the parameters and variance-covariance matrix of the parameters.
}
\examples{
# Alloy T7987 dataset taken from Meeker and Escobar(1998, p. 131)
cycles   <- c(300, 300, 300, 300, 300, 291, 274, 271, 269, 257, 256, 227, 226,
              224, 213, 211, 205, 203, 197, 196, 190, 189, 188, 187, 184, 180,
              180, 177, 176, 173, 172, 171, 170, 170, 169, 168, 168, 162, 159,
              159, 159, 159, 152, 152, 149, 149, 144, 143, 141, 141, 140, 139,
              139, 136, 135, 133, 131, 129, 123, 121, 121, 118, 117, 117, 114,
              112, 108, 104, 99, 99, 96, 94)
state <- c(rep(0, 5), rep(1, 67))

# Example 1: Evaluating Log-Likelihood function of two-parametric weibull:
loglik_weib <- loglik_function(x = cycles, event = state, pars = c(5.29, 0.33),
                               distribution = "weibull")

# Example 2: Evaluating Log-Likelihood function of three-parametric weibull:
loglik_weib3 <- loglik_function(x = cycles, event = state,
                                pars = c(4.54, 0.76, 92.99),
                                distribution = "weibull3")
}
\references{
Meeker, William Q; Escobar, Luis A., Statistical methods for
  reliability data, New York: Wiley series in probability and statistics, 1998
}
