% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot_stim}
\alias{plot_stim}
\title{Plot stimuli}
\usage{
plot_stim(
  stimuli,
  nrow = NULL,
  ncol = NULL,
  byrow = TRUE,
  padding = 10,
  external_pad = TRUE,
  fill = wm_opts("fill"),
  maxwidth = wm_opts("plot.maxwidth"),
  maxheight = wm_opts("plot.maxheight")
)
}
\arguments{
\item{stimuli}{list of class stimlist}

\item{nrow}{number of rows}

\item{ncol}{number of columns}

\item{byrow}{fill grid by rows (first ncol images in the first row); if FALSE, fills by columns (first nrow images in the first column)}

\item{padding}{around each image in pixels}

\item{external_pad}{whether to include external padding}

\item{fill}{background color, see \code{\link[=color_conv]{color_conv()}}}

\item{maxwidth, maxheight}{maximum width and height of grid in pixels}
}
\value{
stimlist with the plot image (no templates)
}
\description{
Show all the stimuli in a grid. You can use \code{\link[=plot]{plot()}} as an alias.
}
\examples{
stimuli <- demo_stim() |> resize(0.5)
plot_stim(stimuli)

\donttest{
# default padding is 10px internal and external
plot(stimuli, fill = "dodgerblue")
plot(stimuli, external_pad = 0, fill = "dodgerblue")
plot(stimuli, padding = 0, fill = "dodgerblue")

# make 8 numbered images
n <- blank(8, color = grDevices::cm.colors(8)) |> 
  label(1:8, gravity = "center", size = 50)

# 2 rows, allocating by row
plot(n, nrow = 2)

# 2 rows, allocating by column
plot(n, nrow = 2, byrow = FALSE)
}
}
\seealso{
Visualisation functions
\code{\link{as_ggplot}()},
\code{\link{draw_tem}()},
\code{\link{gglabel}()},
\code{\link{label}()},
\code{\link{mlabel}()},
\code{\link{plot.stimlist}()},
\code{\link{plot.stim}()},
\code{\link{plot_rows}()}
}
\concept{viz}
