% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mask.R
\name{mask}
\alias{mask}
\title{Mask Images with templates}
\usage{
mask(
  stimuli,
  mask = "face",
  fill = wm_opts("fill"),
  reverse = FALSE,
  expand = 1,
  tem_id = "frl"
)
}
\arguments{
\item{stimuli}{list of stimuli}

\item{mask}{vector of masks or a custom list of template points}

\item{fill}{color to make the mask, see \code{\link[=color_conv]{color_conv()}}}

\item{reverse}{logical; whether the mask covers the areas outside (FALSE) or inside (TRUE) the mask}

\item{expand}{how many pixels to expand the mask (negative numbers contract the mask)}

\item{tem_id}{template ID to pass on to \code{\link[=tem_def]{tem_def()}} to get built-in mask definitions}
}
\value{
list of stimuli with masked images
}
\description{
Use template points to define the borders of a mask to apply to the images. The image outside of the mask (or inside, if \code{reverse = TRUE}) is replaced by the fill color.
}
\details{
For FRL templates, the argument \code{mask} can be a vector with one or more of the following: oval, face, neck, ears (left_ear, right_ear), eyes (left_eye, right_eye), brows (left_brow, right_brow), mouth, teeth, nose.

For Face++ templates (fpp83 or fpp106), the argument \code{mask} can be a vector with one or more of the following: face, eyes (left_eye, right_eye), brows (left_brow, right_brow), mouth, teeth, nose. Because these templates have no forehead points, "face" is usually disappointing.

Set custom masks using the template points (0-based). View an image with labelled templates using \code{plot(stim, pt.plot = TRUE, pt.shape="index")}. Separate points along a line with commas, line segments with semicolons, and mask areas with colons. For example, this would be the custom mask for the eyes in the fpp83 template:

\code{"44,4,56,51,79;79,58,11,25,44:61,67,38,34,40;40,41,17,47,61"}

If you set expand = 0, there is sometimes a thin visible line where multiple components of the mask touch.
}
\examples{
stimuli <- demo_stim()

mask(stimuli, 
     mask = c("face", "neck", "ears"), 
     fill = "dodgerblue")

mask(stimuli, "face", expand = 30)

\donttest{
# reverse masking masks over the features
stimuli |>
  mask("eyes", "#FFFF00", TRUE) |>
  mask("brows", rgb(0.2, 0.5, 0.5), TRUE) |>
  mask("mouth", "#FF000066", TRUE)
  
# custom mask (list style)
fpp83_eyes <- list(
  left_eye = list(
    c(44,4,56,51,79),
    c(79,58,11,25,44)
  ),
  right_eye = list(
    c(61,67,38,34,40),
    c(40,41,17,47,61)
  )
)

demo_tems("fpp83") |>
  mask(fpp83_eyes, fill = color_conv("dodgerblue", alpha = 0.5))
}

}
\seealso{
Stimulus manipulation functions
\code{\link{align}()},
\code{\link{crop_tem}()},
\code{\link{crop}()},
\code{\link{greyscale}()},
\code{\link{horiz_eyes}()},
\code{\link{image_func}()},
\code{\link{mask_oval}()},
\code{\link{mirror}()},
\code{\link{pad}()},
\code{\link{resize}()},
\code{\link{rotate}()},
\code{\link{to_size}()}
}
\concept{manipulators}
