% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/webmockr-opts.R
\name{webmockr_configure}
\alias{webmockr_configure}
\alias{webmockr_configure_reset}
\alias{webmockr_configuration}
\alias{webmockr_allow_net_connect}
\alias{webmockr_disable_net_connect}
\alias{webmockr_net_connect_allowed}
\title{webmockr configuration}
\usage{
webmockr_configure(
  allow_net_connect = FALSE,
  allow_localhost = FALSE,
  allow = NULL,
  show_stubbing_instructions = TRUE,
  show_body_diff = FALSE
)

webmockr_configure_reset()

webmockr_configuration()

webmockr_allow_net_connect()

webmockr_disable_net_connect(allow = NULL)

webmockr_net_connect_allowed(uri = NULL)
}
\arguments{
\item{allow_net_connect}{(logical) Default: \code{FALSE}}

\item{allow_localhost}{(logical) Default: \code{FALSE}}

\item{allow}{(character) one or more URI/URL to allow (and by extension
all others are not allowed)}

\item{show_stubbing_instructions}{(logical) Default: \code{TRUE}. If \code{FALSE},
stubbing instructions are not shown}

\item{show_body_diff}{(logical) Default: \code{FALSE}. If \code{TRUE} show's
a diff of the stub's request body and the http request body. See also
\code{\link[=stub_body_diff]{stub_body_diff()}} for manually comparing request and stub bodies.
Under the hood the Suggested package \code{diffobj} is required to do
the comparison.}

\item{uri}{(character) a URI/URL as a character string - to determine
whether or not it is allowed}
}
\description{
webmockr configuration
}
\section{webmockr_allow_net_connect}{

If there are stubs found for a request, even if net connections are
allowed (by running \code{webmockr_allow_net_connect()}) the stubbed
response will be returned. If no stub is found, and net connections
are allowed, then a real HTTP request can be made.
}

\examples{
\dontrun{
webmockr_configure()
webmockr_configure(
  allow_localhost = TRUE
)
webmockr_configuration()
webmockr_configure_reset()

webmockr_allow_net_connect()
webmockr_net_connect_allowed()

# disable net connect for any URIs
webmockr_disable_net_connect()
### gives NULL with no URI passed
webmockr_net_connect_allowed()
# disable net connect EXCEPT FOR given URIs
webmockr_disable_net_connect(allow = "google.com")
### is a specific URI allowed?
webmockr_net_connect_allowed("google.com")

# show body diff
webmockr_configure(show_body_diff = TRUE)
}
}
