% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/request_registry.R
\name{request_registry}
\alias{request_registry}
\alias{request_registry_clear}
\title{List or clear requests in the request registry}
\usage{
request_registry()

request_registry_clear()
}
\value{
an object of class \code{RequestRegistry}, print method gives the
requests in the registry and the number of times each one has been
performed
}
\description{
List or clear requests in the request registry
}
\details{
\code{request_registry()} lists the requests that have been made
that webmockr knows about; \code{request_registry_clear()} resets the
request registry (removes all recorded requests)
}
\examples{
webmockr::enable()
stub_request("get", "https://httpbin.org/get") \%>\%
  to_return(body = "success!", status = 200)

# nothing in the request registry
request_registry()

# make the request
z <- crul::HttpClient$new(url = "https://httpbin.org")$get("get")

# check the request registry - the request was made 1 time
request_registry()

# do the request again
z <- crul::HttpClient$new(url = "https://httpbin.org")$get("get")

# check the request registry - now it's been made 2 times, yay!
request_registry()

# clear the request registry
request_registry_clear()
webmockr::disable()
}
\seealso{
Other request-registry: 
\code{\link{HashCounter}},
\code{\link{RequestRegistry}}
}
\concept{request-registry}
