% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/webdav.R
\name{webdav_copy_file}
\alias{webdav_copy_file}
\title{Copy a resource on the WebDAV server}
\usage{
webdav_copy_file(
  base_url,
  from_path,
  to_path,
  username = Sys.getenv("WEBDAV_USERNAME"),
  password = Sys.getenv("WEBDAV_PASSWORD"),
  verbose = FALSE
)
}
\arguments{
\item{base_url}{The base URL of the WebDAV server.}

\item{from_path}{The source path of the resource to copy.}

\item{to_path}{The destination path where the resource will be copied.}

\item{username}{The username for WebDAV authentication. Defaults to the "WEBDAV_USERNAME" environment variable.}

\item{password}{The password for WebDAV authentication. Defaults to the "WEBDAV_PASSWORD" environment variable.}

\item{verbose}{Logical. If TRUE, prints detailed messages during the copy process.}
}
\value{
Logical value indicating whether the resource was copied successfully.
}
\description{
This function copies a resource from one URI to another on the WebDAV server using the COPY method.
It validates the provided parameters and handles errors during the copy process.
}
\examples{
# Example usage with a public WebDAV server.
# Visit test_server$url link to view the results of the operation.
library(magrittr)
library(httr2)
test_server <- "https://www.webdavserver.com/" \%>\%
  request() \%>\%
  req_retry(max_tries = 3, max_seconds = 4, backoff =  ~ 1) \%>\%
  req_perform() \%>\%
  try(silent = TRUE)

# Copy a file from one path to another
if (class(test_server) != "try-error")
  webdav_copy_file(base_url = test_server$url,
    from_path = "Project.pdf",
    to_path = "New_Project.pdf",
    verbose = TRUE)
}
