% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{is.smiles}
\alias{is.smiles}
\title{Check if input is a SMILES string}
\usage{
is.smiles(x, verbose = TRUE)
}
\arguments{
\item{x}{character; input SMILES.}

\item{verbose}{logical; print messages during processing to console?}
}
\value{
a logical
}
\description{
This function checks if a string is a valid SMILES by checking if (R)CDK can parse it.
If it cannot be parsed by rcdk FALSE is returned, else TRUE.
}
\note{
This function can handle only one SMILES string.
}
\examples{
\dontrun{
# might fail if rcdk is not working properly
is.smiles('Clc(c(Cl)c(Cl)c1C(=O)O)c(Cl)c1Cl')
is.smiles('Clc(c(Cl)c(Cl)c1C(=O)O)c(Cl)c1ClJ')
}
}
\references{
Egon Willighagen (2015). How to test SMILES strings in Supplementary Information.
\url{https://chem-bla-ics.blogspot.nl/2015/10/how-to-test-smiles-strings-in.html}
}
\author{
Eduard Szoecs, \email{eduardszoecs@gmail.com}
}
