% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/etox.R
\name{get_etoxid}
\alias{get_etoxid}
\title{Get ETOX ID}
\usage{
get_etoxid(query, verbose = TRUE)
}
\arguments{
\item{query}{character; The searchterm}

\item{verbose}{logical; print message during processing to console?}
}
\value{
A character vector with the substance ID and additional attributes \code{matched}  (the matched
substance name) and \code{distance} (the normalized string distance of the query to the match).
}
\description{
Query ETOX: Information System Ecotoxicology and Environmental Quality Targets
\url{http://webetox.uba.de/webETOX/index.do} for their substance ID
}
\note{
If more than one reference is found only the first hit is taken.
Before using this function, please read the disclaimer \url{http://webetox.uba.de/webETOX/disclaimer.do}.
}
\examples{
\dontrun{
get_etoxid('Triclosan')
# multiple inpus
comps <- c('Triclosan', 'Glyphosate')
sapply(comps, get_etoxid)
}
}
\author{
Eduard Szoecs, \email{eduardszoecs@gmail.com}
}
\seealso{
\code{\link{get_etoxid}} to retrieve ETOX IDs, \code{\link{etox_basic}} for basic information,
\code{\link{etox_targets}} for quality targets and \code{\link{etox_tests}} for test results.
}

