% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrapper_functions.R
\name{getTemperatureForDate}
\alias{getTemperatureForDate}
\title{Getting Temperature data for a single date (or a range of dates)}
\usage{
getTemperatureForDate(station_id, start_date, end_date = NULL,
  station_type = "airportCode", daily_min = FALSE, daily_max = FALSE,
  opt_write_to_file = FALSE)
}
\arguments{
\item{station_id}{is a valid station code or a valid Weather Station ID
(example: "BUF", "ORD", "VABB" for Mumbai).
Valid Weather Station "id" values: "KFLMIAMI75" or "IMOSCOWO2" You can look up
 weather station IDs at wunderground.com}

\item{start_date}{is a valid string representing a date in the past (YYYY-MM-DD, all numeric)}

\item{end_date}{(optional) If an interval is to be specified, end_date 
is a a valid string representing a date in the past (YYYY-MM-DD, all numeric) 
and greater than start_date}

\item{station_type}{= "airportCode" (4-letter airport code) or "ID" (Wx call Sign)}

\item{daily_min}{A boolean indicating if only the Minimum Temperatures are desired}

\item{daily_max}{A boolean indicating if only the Maximum Temperatures are desired}

\item{opt_write_to_file}{If TRUE, the resulting dataframe will be stored in a CSV file. 
Default is FALSE}
}
\value{
A data frame with each row containing: \itemize{
\item Date and Time stamp (for each date specified)
\item Temperature values
}
}
\description{
This function will return a (fairly large) data frame. If you are going 
 to be using this data for future analysis, you can store the results in a CSV file
  by setting \code{opt_write_to_file} to be TRUE
}
\details{
For each day in the date range, this function fetches Temperature Data. It will fetch
all the available values, which is typically multiple rows for each day, with a time stamp.
 This function is a light wrapper for  \code{getWeatherForDate}.
}
\references{
For a list of valid Weather Stations, try this format
 \url{http://www.wunderground.com/weatherstation/ListStations.asp?selectedCountry=United+States}
 and replace with your country of interest
}
\seealso{
getWeatherForDate, getDetailedWeather
}
