% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/joint_dist.R
\name{get_eta_directed}
\alias{get_eta_directed}
\title{Compute edge-level distributions for directed networks with respect to
desired assortativity level(s).}
\usage{
get_eta_directed(
  edgelist,
  target.assortcoef = list(outout = NULL, outin = NULL, inout = NULL, inin = NULL),
  eta.obj = function(x) 0,
  which.range,
  control = cvxr_control()
)
}
\arguments{
\item{edgelist}{A two-column matrix representing the directed edges of a
network.}

\item{target.assortcoef}{A list representing the predetermined value or range
of assortativity coefficients.}

\item{eta.obj}{A convex function of \code{eta} to be minimized when
\code{which.range} is \code{NULL}. Defaults to 0.}

\item{which.range}{Character, "outout", "outin", "inout" or "inin"s,
represents the interested degree based assortativity coefficient.}

\item{control}{A list of parameters passed to \code{CVXR::solve()} when
solving for \code{eta} or computing the range of assortativity coefficient.}
}
\value{
Assortativity coefficients and joint distributions. If
  \code{which.range} is specified, the range of the interested coefficient
  and the corresponding joint distributions will be returned, provided the
  predetermined \code{target.assortcoef} is satisfied.
}
\description{
Compute edge-level distributions for directed networks with respect to
desired assortativity level(s).
}
\keyword{internal}
