% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/centrality.R
\name{closeness_c}
\alias{closeness_c}
\title{Closeness centrality}
\usage{
closeness_c(
  adj,
  alpha = 1,
  mode = "out",
  method = "harmonic",
  distance = FALSE
)
}
\arguments{
\item{adj}{is an adjacency matrix of a weighted and directed network}

\item{alpha}{is a tuning parameter. The value of alpha must be nonnegative. By convention, 
alpha takes a value from 0 to 1 (default).}

\item{mode}{which mode to compute: "out" (default) or "in"? For undirected networks, this
setting is irrelevant.}

\item{method}{which method to use: "harmonic" (default) or "standard"?}

\item{distance}{whether to consider the entries in the adjacency matrix as distances or
strong connections. The default setting is \code{FALSE}.}
}
\value{
a list of node names and associated closeness centrality measures
}
\description{
Compute the closeness centrality measures of the vertices in a weighted and directed 
network represented through its adjacency matrix.
}
\note{
Function \code{closeness_c} is an extension of function \code{closeness} 
in package \code{igraph} and function \code{closeness_w} in 
package \code{tnet}. The method of computing distances between vertices
is the \emph{Dijkstra's algorithm}.
}
\references{
\itemize{
\item Dijkstra, E.W. (1959). A note on two problems in connexion with 
graphs. \emph{Numerische Mathematik}, 1, 269--271.
\item Newman, M.E.J. (2003). The structure and function of complex
networks. \emph{SIAM review}, 45(2), 167--256.
\item Opsahl, T., Agneessens, F., Skvoretz, J. (2010). Node centrality 
in weighted networks: Generalizing degree and shortest paths. 
\emph{Social Networks}, 32, 245--251.
\item Zhang, P., Zhao, J. and Yan, J. (2020+) Centrality measures of 
networks with application to world input-output tables
}
}
\keyword{internal}
