% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wdi_get_topics.R
\name{wdi_get_topics}
\alias{wdi_get_topics}
\title{Download topics from the World Bank API}
\source{
https://api.worldbank.org/v2/topics
}
\usage{
wdi_get_topics(language = "en")
}
\arguments{
\item{language}{A character string specifying the language code for the API
response (default is "en" for English).}
}
\value{
A tibble with three columns:
\describe{
\item{id}{The unique identifier for the topic.}
\item{value}{The name of the topic (e.g., "Education", "Health").}
\item{source_note}{A brief description or note about the topic.}
}
}
\description{
This function returns a tibble of supported topics for querying the World
Bank API. Topics represent the broad subject areas covered by the World
Bank's datasets.
}
\details{
This function provides a reference for the supported topics that can
be used to refine your queries when accessing the World Bank API. Topics
represent different areas of focus for data analysis.
}
\examples{
\dontshow{if (curl::has_internet()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Download all available topics in English
wdi_get_topics()
\dontshow{\}) # examplesIf}
}
