% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/end_points.R
\name{wb_indicators}
\alias{wb_indicators}
\title{Download Avialable Indicators from the World Bank}
\usage{
wb_indicators(lang, include_archive = FALSE)
}
\arguments{
\item{lang}{Language in which to return the results. If \code{lang} is unspecified,
english is the default. For supported languages see \code{\link[=wb_languages]{wb_languages()}}.
Possible values of \code{lang} are in the \code{iso2} column. A note of warning, not
all data returns have support for langauges other than english. If the specific
return does not support your requested language by default it will return \code{NA}.}

\item{include_archive}{\code{logical}. If \code{TRUE} indicators that have been archived
by the World Bank will be included in the return. Data for these additional
indicators are not available through the standard API and querying them
using \code{\link[=wb_data]{wb_data()}} will not return data. Default is \code{FALSE}.}
}
\description{
This function returns a \link[tibble:tibble-package]{tibble} of indicator IDs and related information
that are available for download from the World Bank API
}
\examples{
# can get a new list of available indicators by downloading new cache
\donttest{fresh_cache <- wb_cache()}
\donttest{fresh_indicators <- fresh_cache$indicators}

# or by running the wb_indicators() function directly
\donttest{fresh_indicators <- wb_indicators()}

# fresh indicators but in spanish
# a note of warning, please see the lang parameter description
\donttest{fresco_indicators <- wb_indicators("es")}

# include archived indicators
# see include_archive parameter description
\donttest{indicators_with_achrive <- wb_indicators(include_archive = TRUE)}
}
