% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classfunctions.R
\name{summary.wasp}
\alias{summary.wasp}
\title{Posterior summaries for the Wasserstein barycenter of subset posteriors}
\usage{
\method{summary}{wasp}(x)
}
\arguments{
\item{x}{a \code{wasp} object obtained from the function \code{wasp()}.}
}
\value{
Posterior summary statistics (mean, mode, sd, 95% HPD interval) for
  all the Wasserstein barycenter of subset posteriors of all parameters in
  the model.
}
\description{
Outputs and prints posterior summary statistics (mean, mode, sd, 95% Highest
Posterior Density interval)
}
\examples{
library(waspr)
out <- wasp(pois_logistic,
            par.names = c("beta_s", "alpha_l", "beta_l",
                          "baseline_sigma", "baseline_mu",
                          "correlation", "sigma_s", "sigma_l"))
summary(out)

}
