% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/song_analysis.R
\name{song_analysis}
\alias{song_analysis}
\title{Calculates acoustic parameters at the song level}
\usage{
song_analysis(X = NULL, song_colm = "song",mean_colm = NULL, min_colm = NULL,
max_colm = NULL, elm_colm = NULL, elm_fun = NULL, sd = FALSE, parallel = 1, pb = TRUE,
na.rm = FALSE, weight = NULL)
}
\arguments{
\item{X}{'selection_table', 'extended_selection_table' (created 'by.song') or data frame with the following columns: 1) "sound.files": name of the sound
files, 2) "selec": number of the selections, 3) "start": start time of selections, 4) "end":
end time of selections.}

\item{song_colm}{Character string with the column name containing song labels.
It can be used to label any hierarchical level at which parameters need to be calculated (e.g. syllables, phrases).
Note that
the function assumes that song labels are not repeated within a sound file.}

\item{mean_colm}{Numeric vector with the index of the columns that will be averaged. If \code{NULL} the mean of all numeric columns in 'X' is returned.}

\item{min_colm}{Character vector with the name(s) of the columns for which the minimum
value is needed. Default is \code{NULL}.}

\item{max_colm}{Character vector with the name(s) of the columns for which the maximum
value is needed. Default is \code{NULL}.}

\item{elm_colm}{Character vector with the name(s) of the columns identifying the element labels (i.e. element types). If supplied 'unq.elms' and 'mean.elm.count' are returned. Default is \code{NULL}.}

\item{elm_fun}{Function to be applied to the sequence of elements composing a song. Default is \code{NULL}. Ignored if 'elm_colm' is not supplied. The name of the column containing the function's output is "elm_fun'.}

\item{sd}{Logical value indicating whether standard deviation is also returned for
variables in which averages are reported. Default is \code{FALSE}.}

\item{parallel}{Numeric. Controls whether parallel computing is applied.
It specifies the number of cores to be used. Default is 1 (i.e. no parallel computing).}

\item{pb}{Logical argument to control progress bar and messages. Default is \code{TRUE}.}

\item{na.rm}{Logical value indicating whether 'NA' values should be ignored for calculations.}

\item{weight}{Character vector defining 1 or more numeric vectors to weight average
measurements (i.e. song parameters). Names of numeric columns in 'X' can also be used. See \code{\link[stats]{weighted.mean}}.
 for more details.  Default is \code{NULL} (unweighted average).}
}
\value{
A data frame similar to the input 'X' data frame, but in this case each row corresponds to a single song. The data frame contains the mean or extreme
 values for numeric columns for each song. Columns that will be averaged can be defined with
 'mean_colm' (otherwise all numeric columns are used). Columns can be
 weighted by other columns in the data set (e.g. duration, frequency range). In addition, the function returns the following song level parameters:
\itemize{
   \item \code{elm.duration}: mean length of elements (in s)
   \item \code{song.duration}: length of song (in s)
   \item \code{num.elms}: number of elements (or song units)
   \item \code{start}: start time of song (in s)
   \item \code{end}: end time of song (in s)
   \item \code{bottom.freq}: lowest 'bottom.freq' from all song elements (in kHz)
   \item \code{top.freq}: highest 'top.freq' from all song elements (in kHz)
   \item \code{freq.range}: difference between song's 'top.freq' and 'bottom.freq' (in kHz)
   \item \code{song.rate}: number of elements per second (NA if only 1 element). Calculated as the number of elements in the 'song' divided by the duration of the song. In this case song duration is calculated as the time between the start of the first element and the start of the last element, which provides a rate that is less affected by the duration of individual elements. Note that this calculation is different than that from 'song.duration' above.
   \item \code{gap.duration}: average length of gaps (i.e. silences) in between elements
   (in s, NA if only 1 element)
   \item \code{elm.types}: number of element types (i.e. number of unique types, only if 'elm_colm' is supplied)
   \item \code{mean.elm.count}: mean number of times element types are found (only if 'elm_colm' is supplied)
   }
   This function assumes that song labels are not repeated within a sound file.
}
\description{
\code{song_analysis} calculates descriptive statistics of songs or other higher levels of organization in the signals.
}
\details{
The function calculates average or extreme values of acoustic parameters of
elements in a song or other level of organization in the signals.
}
\examples{
{
# get warbleR sound file examples
data(list = c("Phae.long1", "Phae.long2", "Phae.long3", "Phae.long4", "lbh_selec_table"))
writeWave(Phae.long1, file.path(tempdir(), "Phae.long1.wav"))
writeWave(Phae.long2, file.path(tempdir(), "Phae.long2.wav"))
writeWave(Phae.long3, file.path(tempdir(), "Phae.long3.wav"))

# add a 'song' column
lbh_selec_table$song <- c("song1", "song1", "song1", "song2",
  "song2", "song3", "song3", "song3", "song4", "song4", "song4")

# measure acoustic parameters
sp <- spectro_analysis(lbh_selec_table[1:8, ], bp = c(1, 11), 300, fast = TRUE, path = tempdir())

# add song data
sp <- merge(sp, lbh_selec_table[1:8, ], by = c("sound.files", "selec"))

# caculate song-level parameters for all numeric parameters
song_analysis(X = sp, song_colm = "song", parallel = 1, pb = TRUE)

# caculate song-level parameters selecting parameters with mean_colm
song_analysis(X = sp, song_colm = "song",mean_colm = c("dfrange", "duration"),
 parallel = 1, pb = TRUE)

# caculate song-level parameters for selecting parameters with mean_colm, max_colm
# and min_colm and weighted by duration
song_analysis(X = sp, weight = "duration", song_colm = "song",
mean_colm =  c("dfrange", "duration"), min_colm =  "mindom", max_colm = "maxdom",
  parallel = 1, pb = TRUE)

# with two weights
song_analysis(X = sp, weight = c("duration", "dfrange"), song_colm = "song",
mean_colm = c("kurt", "sp.ent"), parallel = 1, pb = TRUE)

# with two weights no progress bar
song_analysis(X = sp, weight = c("duration", "dfrange"), song_colm = "song",
mean_colm = c("kurt", "sp.ent"), parallel = 1, pb = FALSE)
}

}
\references{
{
Araya-Salas, M., & Smith-Vidaurre, G. (2017). warbleR: An R package to streamline analysis of animal acoustic signals. Methods in Ecology and Evolution, 8(2), 184-191.
}
}
\seealso{
\code{\link{spectro_analysis}}
}
\author{
Marcelo Araya-Salas (\email{marcelo.araya@ucr.ac.cr})
}
