% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coor.test.R
\name{coor.test}
\alias{coor.test}
\title{Randomization test for singing coordination}
\usage{
coor.test(X, iterations = 1000, less.than.chance = TRUE, parallel = 1, pb = TRUE, 
rm.incomp = FALSE, cutoff = 2, rm.solo = FALSE)
}
\arguments{
\item{X}{Data frame containing columns for singing event (sing.event), 
individual (indiv), and start and end time of signal (start and end).}

\item{iterations}{number of iterations for shuffling and calculation of the expected number of overlaps. Default is 1000.}

\item{less.than.chance}{Logical. If \code{TRUE} the test evaluates whether overlaps occur less often than expected by chance.
If \code{FALSE} the opposite pattern is evaluted (whether overlaps occur more often than expected by chance). 
Default is  \code{TRUE}.}

\item{parallel}{Numeric. Controls whether parallel computing is applied.
It specifies the number of cores to be used. Default is 1 (i.e. no parallel computing).}

\item{pb}{Logical argument to control progress bar. Default is \code{TRUE}.}

\item{rm.incomp}{Logical. If \code{TRUE} removes the events that don't have 2 interacting individuals. Default is
\code{FALSE}.}

\item{cutoff}{Numeric. Determines the minimum number of signals per individual in a singing event. Events not meeting 
this criterium are removed if rm.incomp is \code{TRUE}. If rm.icomp is \code{FALSE} cutoff is ignored. Default is 2. 
Note that randomization tests are not reliable with very small sample sizes. Ideally 10 or more signals per individual 
should be available in each singing event.}

\item{rm.solo}{Logical. Controls if signals that are not intercalated at the start or end of the 
sequence are removed (if \code{TRUE}). For instances the sequence of signals A-A-A-B-A-B-A-B-B-B (in which A and B represent different individuals, as in the 'indiv' column) would be subset to 
A-B-A-B-A-B. Default is  \code{FALSE}.}
}
\value{
A data frame with the following columns:
#' \itemize{
   \item \code{sing.event}: singing event ID
   \item \code{obs.overlaps}: observed number of overlaps
   \item \code{mean.random.ovlps}: mean number of overlaps expected by chance
   \item \code{p.value}: p value 
   \item \code{coor.score}: coordination score (**sensu** Araya-Salas et al. 2017), 
   calculated as `(obs.overlaps - mean.random.ovlps) / mean.random.ovlps`. 
   Positive values indicate a tendency to overlap while negative values indicate a tendency to alternate.
   }
}
\description{
Monte Carlo randomization test to assess the statistical significance of overlapping or alternating singing
}
\details{
This function calculates the probability of finding an equal or lower number 
(or higher if les.than.chance is \code{TRUE}) of song overlaps in a coordinated singing event. 
The function shuffles the sequences of signals and silence-between-signals for both individuals to produce 
a null distribution of number of overlaps expected by chance. The observed number of overlaps is compared to this
expected values. The p-values are calculated as the proportion of random expected values that were lower (or higher) 
than the observed value. The function runs one test for each singing event in the input data frame. The function 
is equivalent to the "KeepGaps" methods described in Masco et al. 2015.
}
\examples{
{
#load  simulated singing data (see data documentation)
data(sim_coor_sing)

# testing if coordination happens less than expected by chance
coor.test(sim_coor_sing, iterations = 100, less.than.chance = TRUE)

# testing if coordination happens more than expected by chance
coor.test(sim_coor_sing, iterations = 100, less.than.chance = FALSE)
}

}
\references{
{
Araya-Salas, M., & Smith-Vidaurre, G. (2017). warbleR: An R package to streamline analysis of animal acoustic signals.
 Methods in Ecology and Evolution, 8(2), 184-191.

Araya-Salas M., Wojczulanis-Jakubas K., Phillips E.M., Mennill D.J., Wright T.F.\
 (2017) To overlap or not to overlap: context-dependent coordinated singing in 
 lekking long-billed hermits. Anim Behav.

Masco, C., Allesina, S., Mennill, D. J., and Pruett-Jones, S. (2015). The Song 
Overlap Null model Generator (SONG): a new tool for distinguishing between random
and non-random song overlap. Bioacoustics.
}
}
\author{
Marcelo Araya-Salas (\email{araya-salas@cornell.edu})
}
