% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/specan_1.2.R
\name{specan}
\alias{specan}
\title{Measure acoustic parameters in batches of sound files}
\usage{
specan(X, bp = c(0,22), wl = 512, threshold = 15)
}
\arguments{
\item{X}{data frame with the following columns: 1) "start": start time of
selections, 2) "end": end time of selections, 3) "rec": name of the .wav
files, and 4) "sel": number of the selections. The output from manualoc()
could be use directly.}

\item{bp}{numeric vector of length two giving the lower and upper limits of a
frequency bandpass filter (in kHz). Default is c(0, 22).}

\item{wl}{windows length controls the length of the individual spectra that
together produce the spectrogram. Default is 512.}

\item{threshold}{\% amplitude threshold for fundamental frequency and dominant frequency detection.
Default is 15.}
}
\value{
Data frame with the following acoustic parameters:
\itemize{
   \item \code{duration}: length of signal
   \item \code{meanfreq}: mean frequency (in kHz)
   \item \code{sd}: standard deviation of frequency
   \item \code{median}: median frequency (in kHz)
   \item \code{Q25}: first quantile (in kHz)
   \item \code{Q75}: third quantile (in kHz)
   \item \code{IQR}: interquantile range (in kHz)
   \item \code{skew}: skewness (see note in code{\link[seewave]{specprop}} description from seewave package)
   \item \code{kurt}:  kurtosis (see note in code{\link[seewave]{specprop}} description from seewave package)
   \item \code{sp.ent}: spectral entropy
   \item \code{sfm}: spectral flatness
   \item \code{mode}: mode frequency
   \item \code{centroid}: centroid
   \item \code{peakf}: peak frequency (frequency with highest energy)
   \item \code{meanfun}: average of fundamental frequency measured across acoustic signal
   \item \code{minfun}: minimum fundamental frequency measured across acoustic signal
   \item \code{maxfun}: maximum fundamental frequency measured across acoustic signal
   \item \code{meandom}: average of dominant frequency measured across acoustic signal
   \item \code{mindom}: minimum of dominant frequency measured across acoustic signal
   \item \code{maxdom}: maximum of dominant frequency measured across acoustic signal
   \item \code{dfrange}: range of dominant frequency measured across acoustic signal
   \item \code{modindx}: modulation index. Is calculated as the accumulated absolute
     difference between adjacent measurements of fundamental frequencies divided
     by the frequency range
}
}
\description{
\code{specan} measure 22 acoustic parameters on acoustic signals for which the start and end times
are provided.
}
\details{
The output of the manualoc function can be used directly without any
  additional modification. The function measures 20 acoustic parameters on
  each selection in the data frame. Most parameters are produced internally by
  the code{\link[seewave]{specprop}}, code{\link[seewave]{fpeaks}}, code{\link[seewave]{fund}},
  and code{\link[seewave]{dfreq}} functions of the seewave package.
}
\examples{
\dontrun{
data(list = c("Phae.long1", "Phae.long2", "Phae.long3", "Phae.long4"))
writeWave(Phae.long1,"Phae.long1.wav")
writeWave(Phae.long2,"Phae.long2.wav")
writeWave(Phae.long3,"Phae.long3.wav")
writeWave(Phae.long4,"Phae.long4.wav")
data(manualoc.df)
a <- specan(X = manualoc.df, bp = c(0, 22))
# using a diferent threshold
a <- specan(X = manualoc.df, bp = c(0, 22), threshold = 20)
# View(a)
}
}
\author{
Marcelo Araya-Salas (http://marceloarayasalas.weebly.com), Grace Smith Vidaurre and Hua Zhong
}

