% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vis_bioclimPlot.R
\name{vis_bioclimPlot}
\alias{vis_bioclimPlot}
\title{vis_bioclimPlot Visualize bivariate plot of BIOCLIM model}
\usage{
vis_bioclimPlot(x, a = 1, b = 2, p = 0.9)
}
\arguments{
\item{x}{bioclim model including values for each environmental layer at
each occurrence point}

\item{a}{numeric Environmental layer to be used as x axis. Default is
layer 1.}

\item{b}{numeric. Environmental layer to be used as x axis. Default is
layer 2.}

\item{p}{numeric. (0-1) percentile distribution to be used for plotting
envelope and showing points outside of envelope. Default is 0.9}
}
\value{
A bivariate plot of environmental values for occurrences. Includes a
  blue rectangle representing the bioclimatic envelope given p. Occurrences
  that are inside the envelope for all layers (included those not plotted)
  are shown as green circles and those outside of the envelope for one ore
  more variables are plotted as orange triangles.
}
\description{
This functions creates a bivariate plot with two of the environmental
  variables used for modeling as x and y axes and occurrences as observations.
}
\details{
This is a bivariate plot with x and y axes representing two of the
  environmental layers used for modeling (user selected although 1 and 2 as
  default). Occurrences used for modeling are shown with differential
  visualization if they are outside of the selected percentile distribution
  (for any variable). Plot also includes a rectangle representing the
  bivariate bioclimatic envelope according to a provided percentile.
}
\examples{
\dontrun{
envs <- envs_userEnvs(rasPath = list.files(system.file("extdata/wc",
                                           package = "wallace"),
                      pattern = ".tif$", full.names = TRUE),
                      rasName = list.files(system.file("extdata/wc",
                                           package = "wallace"),
                      pattern = ".tif$", full.names = FALSE))
occs <- read.csv(system.file("extdata/Bassaricyon_alleni.csv",
                 package = "wallace"))
bg <- read.csv(system.file("extdata/Bassaricyon_alleni_bgPoints.csv",
               package = "wallace"))
partblock <- part_partitionOccs(occs, bg, method = 'block')
m <- model_bioclim(occs, bg, partblock, envs)
bioclimPlot <- vis_bioclimPlot(x = m@models$bioclim,
                               a = 1, b = 2, p = 1)
}

}
\seealso{
\code{\link{model_bioclim}} \code{\link[ENMeval]{ENMevaluate}}
}
\author{
Jamie Kass <jkass@gradcenter.cuny.edu>

Gonzalo E. Pinilla-Buitrago <gepinillab@gmail.com>
}
