% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/occs_paleoDb.R
\name{occs_paleoDb}
\alias{occs_paleoDb}
\title{`occs_paleoDb` query paleobioDB database}
\usage{
occs_paleoDb(spName, occNum, timeInterval, logger = NULL)
}
\arguments{
\item{spName}{character. Species name. For paleobioDb it returns records
associated with the specified taxonomic name, including any synonyms.}

\item{occNum}{integer maximum number of records.}

\item{timeInterval}{character currently a single timeInterval is allowed:
"Holocene" (Holocene).}

\item{logger}{Stores all notification messages to be displayed in the
Log Window of Wallace GUI. Insert the logger reactive list here for
running in shiny, otherwise leave the default NULL}
}
\value{
A list of 2 dataframes. First dataframe is the original downloaded
  dataset, second dataframe without duplicates and with appropriate fields
  for analyses.
}
\description{
query paleobioDB database and returns the complete list of data, data with
  coordinates, and data with no duplicates
}
\details{
This function is called by the module occs_queryDb to query the paleobioDB
  database for species occurrence records in the Holocene. It removes
  records with duplicate coordinates, and selects some columns with fields
  appropriate to studies in biogeography.
}
\examples{
\dontrun{
spName <- "Didelphis virginiana"
occNum <- 100
timeInterval <- "Holocene"
occsPaleo <- occs_paleoDb(spName, occNum, timeInterval)
}
}
\author{
Jamie Kass <jamie.m.kass@gmail.com>

Gonzalo E. Pinilla-Buitrago <gpinillabuitrago@gradcenter.cuny.edu>

Sara Varela <sara_varela@yahoo.com>
}
