% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NetVis.R
\name{NetVis}
\alias{NetVis}
\title{NetVis}
\usage{
NetVis(Node.1, Node.2, wTO, pval = NULL, MakeGroups = FALSE, padj = NULL,
  cutoff = list(kind = "Threshold", value = 0.5), layout = NULL,
  smooth.edges = T, path = NULL, Cluster = F, legend = T,
  shape = list(shape = "triangle", names = NULL), manipulation = F)
}
\arguments{
\item{Node.1}{Names of the Nodes.1 that are connected to the Nodes.2. It's the output from wTO.Complete or Consensus.}

\item{Node.2}{Names of the Nodes.2 that are connected to the Nodes.1. It's the output from wTO.Complete or Consensus.}

\item{wTO}{weight of the links, the wTO output from wTO.Complete or wTO.Consensus.}

\item{pval}{p-values for the wTO value. By default it is NULL.}

\item{MakeGroups}{algorithm to find clusters. One of the followings: walktrap, optimal, spinglass, edge.betweenness, fast_greedy, infomap, louvain, label_prop, leading_eigen. Default to FALSE.}

\item{padj}{Adjusted p-values for the wTO value. By default it is NULL.}

\item{cutoff}{It's a list containing the kind of cutoff to be used (pval, Threshold or pval.adj)and it's value. Example: cutoff= list(kind = "Threshold", value = 0.5)}

\item{layout}{a layout from the igraph package.}

\item{smooth.edges}{If the edges should be smoothed or not.}

\item{path}{If the graph should be saved specify the name of the file.}

\item{Cluster}{TRUE or FALSE if the nodes should be clustered (double click to uncluster).}

\item{legend}{TRUE or FALSE if the legend should appear.}

\item{shape}{a list shape=list(shape = "triangle", names = NULL), with the shape and the IDs that should have a different shape, shape can be: diamond, star, triangle, triangleDown or square.}

\item{manipulation}{TRUE or FALSE if the graph should be editable.}
}
\description{
Given a set of Nodes and the weight of the edges, a cutoff for the edges, it draws the networks. Returns a list with the nodes and edges  attributes. And plots the network.
}
\examples{

 X =  wTO.Complete( k =1, n = 5, Data = Microarray_Expression1,
 Overlap = ExampleGRF$x, method = "p",  plot = FALSE)
# Plot with the default aguments.
 NetVis(Node.1 = X$wTO$Node.1, Node.2 = X$wTO$Node.2,
 wTO = X$wTO$wTO_sign, cutoff = list(kind =
"Threshold", value = 0.50))

\dontrun{
# Plotting just the edges with p-value < 0.05, with straight edges, nodes clustered,
# no legend and mapipulation of the graph enabled.
  NetVis(Node.1 = X$wTO$Node.1, Node.2 = X$wTO$Node.2,
 wTO = X$wTO$wTO_sign, pval = X$wTO$pval_sign,
 padj = X$wTO$pval_sign,
  cutoff= list(kind = "pval", value = 0.05),
  smooth.edges = FALSE,
 Cluster = TRUE, legend = FALSE, manipulation = TRUE)
# Plotting just the edges with wTO > 0.50, no legend and the nodes:
# "ZNF738", "ZNF677" with triagle shape,
# no legend and mapipulation of the graph enabled.
 NetVis(Node.1 = X$wTO$Node.1, Node.2 = X$wTO$Node.2,
 wTO = X$wTO$wTO_sign, pval = X$wTO$pval_sign,
 padj = X$wTO$pval_sign, cutoff= list(kind = "Threshold", value = 0.5),legend = FALSE,
 shape = list(shape = "triangle", names = c("ZNF738", "ZNF677")))

 }
}
\author{
Deisy Morselli Gysi <deisy at bioinf.uni-leipzig.de>
}
