% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wTO.export.R
\name{wTO.export}
\alias{wTO.export}
\title{wTO.export}
\usage{
wTO.export(DATA, path, sign = TRUE, pvalue = 0.05, padj = 0.05,
  prop.NA = 0.5)
}
\arguments{
\item{DATA}{Output from the function wTO.Complete or wTO.Consensus.}

\item{path}{Path and file name where the .txt file should be saved.}

\item{sign}{Should the network contain the results for the signed network or unsigned? Only for data coming from wTO.Complete.}

\item{pvalue}{cutoff p-value for the network. Only for data coming from wTO.Complete.}

\item{padj}{cutoff adjusted p-value for the network. Only for data coming from wTO.Complete.}

\item{prop.NA}{cutoff proportion of NAs for the network. Only for data coming from wTO.Consensus.}
}
\description{
Exports the significative interactions, the wTO weight and pvalues into a .txt file, tab separeted. This file can be imported in other visualization tools (Cytoscape for example).
}
\examples{
\dontrun{
EXAMPLE =  wTO.Complete( k =1, n = 200, Data = ExampledfExpression,
                                      Overlap = ExampleGRF$x, method = "p")
wTO.export(EXAMPLE , './EXAMPLE.txt')

#Selection of only the significative ones for the Consensus
Ex_k1_cor_p_boot_p005_sig = subset(EXAMPLE$wTO,
EXAMPLE$wTO$pval_sig < 0.05,
select = c("Node.1", "Node.2", "wTO_sign"))
Ex_k1_cor_p_boot_p005_abs = subset(EXAMPLE$wTO,
EXAMPLE$wTO$pval_abs < 0.05,
select = c("Node.1", "Node.2", "wTO_abs"))
# Constructing the consensus network
CN = wTO.Consensus(data = list(Ex_k1_cor_p_boot_p005_sig,
Ex_k1_cor_p_boot_p005_abs))
wTO.export(CN, './CN.txt')
### You can store the result on the workspace.
y = wTO.export(CN, './CN.txt')
head(y)
}



}
