% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/remove_user_from_site.R
\name{remove_user_from_site}
\alias{remove_user_from_site}
\title{Remove User from Site}
\usage{
remove_user_from_site(tableau, api_version = 3.19, user_id, mapAssetsTo = NULL)
}
\arguments{
\item{tableau}{A list containing the Tableau authentication variables: `base_url`, `token`, `user_id`, and `site_id`.}

\item{api_version}{The version of the API to use, such as 3.19 (default: 3.19).}

\item{user_id}{The ID of the user to remove.}

\item{mapAssetsTo}{Optional. The ID of a user that receives ownership of contents of the user being removed.}
}
\value{
No return value.
}
\description{
Removes a user from the specified site. The user will be deleted if they do not own any other assets other than subscriptions. If a user still owns content (assets) on Tableau Server, the user cannot be deleted unless the ownership is reassigned first.
}
\seealso{
Other Tableau REST API: 
\code{\link{add_tags_to_view}()},
\code{\link{add_tags_to_workbook}()},
\code{\link{add_user_to_group}()},
\code{\link{add_user_to_site}()},
\code{\link{authenticate_server}()},
\code{\link{create_group}()},
\code{\link{download_filtered_tableau_image}()},
\code{\link{download_tableau_crosstab_excel}()},
\code{\link{download_tableau_data}()},
\code{\link{download_workbooks_server_pdf}()},
\code{\link{download_workbooks_server_powerpoint}()},
\code{\link{download_workbooks_server}()},
\code{\link{get_groups_for_user}()},
\code{\link{get_server_connected_apps}()},
\code{\link{get_server_datasources}()},
\code{\link{get_server_groups}()},
\code{\link{get_server_info}()},
\code{\link{get_server_jobs}()},
\code{\link{get_server_projects}()},
\code{\link{get_server_refresh_tasks}()},
\code{\link{get_server_schedules}()},
\code{\link{get_server_user_favorites}()},
\code{\link{get_server_users}()},
\code{\link{get_server_views}()},
\code{\link{get_server_workbooks}()},
\code{\link{get_table_assets}()},
\code{\link{get_users_in_group}()},
\code{\link{query_user_on_site}()},
\code{\link{remove_user_from_group}()},
\code{\link{update_group}()},
\code{\link{update_user}()}
}
\concept{Tableau REST API}
