% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/segmented_variable.R
\name{solve_piecewisec}
\alias{solve_piecewisec}
\title{Solve as piecewise logit problem, categorical target.}
\usage{
solve_piecewisec(varName, x, y, w = NULL)
}
\arguments{
\item{varName}{character, name of variable}

\item{x}{numeric input (not empty, no NAs).}

\item{y}{numeric or castable to such (same length as x no NAs), output to match}

\item{w}{numeric positive, same length as x (weights, can be NULL)}
}
\value{
segmented y prediction
}
\description{
Return a vector of length y that is a piecewise function of x.
This vector is picked as close to
y (by square-distance) as possible for a set of x-only determined
cut-points.  Cross-validates for a good number of segments.
}
